local AddonName, Kz = ...
local LSM = LibStub("LibSharedMedia-3.0")

LSM:Register("font", "Boris Black Bloxx", [[Interface\AddOns\Kazolitus\BorisBlackBloxx.ttf]])

local CurrentTab = 1

function Kz.CoreUpdate()
    if not Kz.UI.Main or not Kz.UI.Main:IsShown() then return end
    if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end
    
    -- Affichage des Vues
    if Kz.UI.Views.Equip then Kz.UI.Views.Equip:SetShown(CurrentTab == 1) end
    if Kz.UI.Views.Rep then Kz.UI.Views.Rep:SetShown(CurrentTab == 2) end
    if Kz.UI.Views.Raid then Kz.UI.Views.Raid:SetShown(CurrentTab == 3) end
    if Kz.UI.Views.Cur then Kz.UI.Views.Cur:SetShown(CurrentTab == 4) end
    if Kz.UI.Views.Social then Kz.UI.Views.Social:SetShown(CurrentTab == 5) end
    if Kz.UI.Views.Vault then Kz.UI.Views.Vault:SetShown(CurrentTab == 6) end
    if Kz.UI.Views.Options then Kz.UI.Views.Options:SetShown(CurrentTab == 7) end
    
    -- MODIF : Gestion de la vue WQ (Onglet 8)
    if Kz.UI.Views.WQ then Kz.UI.Views.WQ:SetShown(CurrentTab == 8) end

    if Kz.UI.Views.Guild then Kz.UI.Views.Guild:SetShown(CurrentTab == 5) end
    if Kz.UI.SocialTitles then
        local show = (CurrentTab == 5)
        if Kz.UI.SocialTitles.Friends then Kz.UI.SocialTitles.Friends:SetShown(show) end
        if Kz.UI.SocialTitles.Guild then Kz.UI.SocialTitles.Guild:SetShown(show) end
    end
    
    -- Mises à jour Modules
    if CurrentTab == 1 and Kz.Equip and Kz.Equip.Update then Kz.Equip.Update() end
    if CurrentTab == 2 and Kz.Rep and Kz.Rep.Update then Kz.Rep.Update() end
    if CurrentTab == 3 and Kz.Raid and Kz.Raid.Update then Kz.Raid.Update() end
    if CurrentTab == 4 and Kz.Cur and Kz.Cur.Update then Kz.Cur.Update() end
    if CurrentTab == 5 and Kz.Social and Kz.Social.Update then Kz.Social.Update() end
    if CurrentTab == 6 and Kz.Vault and Kz.Vault.Update then Kz.Vault.Update() end
    -- MODIF : Update WQ
    if CurrentTab == 8 and Kz.WQ and Kz.WQ.Update then Kz.WQ.Update() end
    
    -- Boutons
    if Kz.UI.Tabs then
        for id, btn in pairs(Kz.UI.Tabs) do
            if id == CurrentTab and id ~= 7 then -- 7 est toujours Options (Volant)
                btn:SetNormalTexture("Interface\\AddOns\\Kazolitus\\Tab_Selected.tga")
                if btn.text then btn.text:SetTextColor(1, 1, 0) end
            else
                btn:SetNormalTexture("Interface\\AddOns\\Kazolitus\\Tab_Normal.tga")
                if btn.text then btn.text:SetTextColor(0.7, 0.7, 0) end
            end
        end
    end
    
    -- (Code Monnaies inchangé...)
    if not Kz.UI.CurrencyFrames then Kz.UI.CurrencyFrames = {} end
    for _, f in pairs(Kz.UI.CurrencyFrames) do f:Hide() end
    local numCur = C_CurrencyInfo.GetCurrencyListSize()
    local idx = 0; local prevFrame = nil
    for i=1, numCur do
        local info = C_CurrencyInfo.GetCurrencyListInfo(i)
        if info and not info.isHeader and info.isShowInBackpack then
            idx = idx + 1
            if not Kz.UI.CurrencyFrames[idx] then
                local f = CreateFrame("Frame", nil, Kz.UI.Main); f:EnableMouse(true)
                f.icon = f:CreateTexture(nil, "ARTWORK"); f.icon:SetSize(20, 20); f.icon:SetPoint("LEFT")
                f.text = f:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); f.text:SetPoint("LEFT", f.icon, "RIGHT", 5, 0)
                f:SetScript("OnEnter", function(s) GameTooltip:SetOwner(s, "ANCHOR_TOP"); GameTooltip:SetCurrencyToken(s.currIndex); GameTooltip:Show() end)
                f:SetScript("OnLeave", function() GameTooltip:Hide() end)
                Kz.UI.CurrencyFrames[idx] = f
            end
            local f = Kz.UI.CurrencyFrames[idx]
            f.currIndex = i; f.icon:SetTexture(info.iconFileID); f.text:SetText(Kz.FormatNumber(info.quantity))
            if Kz.SkinIcon then Kz.SkinIcon(f.icon) end
            f:SetSize(25 + f.text:GetStringWidth(), 20); f:ClearAllPoints()
            if idx == 1 then f:SetPoint("TOPRIGHT", Kz.UI.Main, "TOPRIGHT", -15, -30) else f:SetPoint("RIGHT", prevFrame, "LEFT", -15, 0) end
            f:Show(); prevFrame = f
        end
    end
end

local f = CreateFrame("Frame")
f:RegisterEvent("ADDON_LOADED")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:RegisterEvent("CURRENCY_DISPLAY_UPDATE")
f:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")

f:SetScript("OnEvent", function(self, event, arg1)
    if event == "ADDON_LOADED" and arg1 == AddonName then
        if not KazolitusDB then KazolitusDB = Kz.DefaultDB end
        local main = Kz.CreateMainFrame()
        local content = Kz.UI.ContentArea
        
        if Kz.Equip and Kz.Equip.Init then Kz.Equip.Init(content) end
        if Kz.Rep and Kz.Rep.Init then Kz.Rep.Init(content) end
        if Kz.Raid and Kz.Raid.Init then Kz.Raid.Init(content) end
        if Kz.Cur and Kz.Cur.Init then Kz.Cur.Init(content) end
        if Kz.Social and Kz.Social.Init then Kz.Social.Init(content) end
        if Kz.Vault and Kz.Vault.Init then Kz.Vault.Init(content) end
        if Kz.Opt and Kz.Opt.Init then Kz.Opt.Init(content) end 
        -- MODIF : Init WQ
        if Kz.WQ and Kz.WQ.Init then Kz.WQ.Init(content) end
        
        Kz.UI.Tabs = {}
        -- MODIF : Ajout de "Expéditions" en position 8. Options reste le bouton spécial.
        -- On réduit légèrement la largeur des boutons (120 -> 110) pour que ça rentre
        local tabNames = {"Équipement", "Réputations", "Raids", "Monnaies", "Social", "Coffre", "Options", "Expéditions"}
        
        -- Ordre d'affichage visuel (On veut Expéditions avant Options visuellement ?)
        -- Simplifions : Gardons l'ordre ID, mais affichons Options à la fin ou au début.
        -- Ici je respecte votre ordre ID : 8 = Expéditions.
        
        local xOffset = 230 -- On décale un peu le début vers la gauche pour faire de la place
        
        for i, name in ipairs(tabNames) do
            local b = CreateFrame("Button", nil, main)
            
            -- Calcul de position
            -- Si c'est Options (7), on le met tout à droite ou à part ?
            -- Mettons-les tous à la suite.
            -- Expéditions sera le bouton 8.
            
            b:SetSize(110, 30) -- Boutons un peu plus petits
            b:SetPoint("BOTTOMLEFT", xOffset + ((i-1)*115), -10)
            
            b:SetNormalTexture("Interface\\AddOns\\Kazolitus\\Tab_Normal.tga")
            b.text = b:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
            b.text:SetPoint("CENTER", 0, 2); b.text:SetText(name)
            
            b:SetScript("OnClick", function() 
                if i == 7 then
                    if Kz.Opt and Kz.Opt.Toggle then Kz.Opt.Toggle() end
                else
                    CurrentTab = i
                    Kz.CoreUpdate() 
                end
            end)
            Kz.UI.Tabs[i] = b
        end
        
        if KazolitusDB.point then main:SetPoint(KazolitusDB.point, UIParent, KazolitusDB.relativePoint, KazolitusDB.x, KazolitusDB.y) end
        self:UnregisterEvent("ADDON_LOADED")
        
    elseif event == "PLAYER_ENTERING_WORLD" then
        Kz.CoreUpdate()
    elseif event == "CURRENCY_DISPLAY_UPDATE" or event == "PLAYER_EQUIPMENT_CHANGED" then
        Kz.CoreUpdate()
    end
end)

local function ToggleKazolitus()
    if not Kz.UI.Main then return end
    if Kz.UI.Main:IsShown() then Kz.UI.Main:Hide() else Kz.UI.Main:Show(); Kz.CoreUpdate() end
end
CharacterFrame:HookScript("OnShow", function() if not InCombatLockdown() then HideUIPanel(CharacterFrame) end end)
hooksecurefunc("ToggleCharacter", function(frameType)
    if frameType == "PaperDollFrame" or not frameType then
        if Kz.UI.Main and Kz.UI.Main:IsShown() then Kz.UI.Main:Hide() else
            if not InCombatLockdown() then if CharacterFrame:IsShown() then HideUIPanel(CharacterFrame) end; if Kz.UI.Main then Kz.UI.Main:Show(); Kz.CoreUpdate() end end
        end
    end
end)
SLASH_KAZOLITUS1 = "/kz"; SlashCmdList["KAZOLITUS"] = ToggleKazolitus