local AddonName, Kz = ...
local LSM = LibStub("LibSharedMedia-3.0")

function Kz.CreateMainFrame()
    local f = CreateFrame("Frame", "KazolitusMain", UIParent, "BackdropTemplate")
    f:SetFrameStrata("HIGH"); f:SetSize(1450, 800); f:SetPoint("CENTER")
    f:SetMovable(true); f:EnableMouse(true); f:RegisterForDrag("LeftButton")
    f:SetScript("OnDragStart", f.StartMoving)
    f:SetScript("OnDragStop", function(self)
        self:StopMovingOrSizing()
        if KazolitusDB then
            local p, _, rp, x, y = self:GetPoint()
            KazolitusDB.point, KazolitusDB.relativePoint, KazolitusDB.x, KazolitusDB.y = p, rp, x, y
        end
    end)
    f:Hide()
    Kz.SkinFrame(f, true); f:SetBackdropBorderColor(0, 0, 0, 0)
    
    f.bgImage = f:CreateTexture(nil, "BACKGROUND", nil, -8)
    f.bgImage:SetAllPoints(f)
    
    local border = f:CreateTexture(nil, "BORDER")
    border:SetTexture("Interface\\AddOns\\Kazolitus\\Border.tga")
    border:SetPoint("TOPLEFT", -50, 50); border:SetPoint("BOTTOMRIGHT", 50, -50)
    
    local Title = f:CreateFontString(nil, "OVERLAY", "GameFontNormalHuge")
    Title:SetPoint("TOP", f, "TOP", 0, -5); Title:SetText("|c"..Kz.ClassColor:GenerateHexColor().."Kazolitus|r")
    Kz.UI.MainTitle = Title
    
    local Close = CreateFrame("Button", nil, f, "UIPanelCloseButton")
    Close:SetPoint("TOPRIGHT", 35, 10); Close:SetScript("OnClick", function() f:Hide() end)
    
    Kz.UI.ContentArea = CreateFrame("Frame", nil, f)
    Kz.UI.ContentArea:SetPoint("TOPLEFT", 0, -50); Kz.UI.ContentArea:SetPoint("BOTTOMRIGHT", 0, 50)
    Kz.UI.Main = f
    return f
end

function Kz.UpdateGlobalVisuals()
    if not Kz.UI.Main then return end
    
    -- 1. Polices
    if not KazolitusDB.Fonts then KazolitusDB.Fonts = {} end
    local function GetFontData(moduleKey)
        local conf = KazolitusDB.Fonts[moduleKey] or {}
        local fName = conf.font or KazolitusDB.font or "Boris Black Bloxx"
        local fSize = conf.size or KazolitusDB.fontSize or 12
        return LSM:Fetch("font", fName), fSize
    end

    local function SetF(obj, moduleKey, modSize)
        if obj and obj.SetFont then
            local path, baseSize = GetFontData(moduleKey)
            if path then obj:SetFont(path, baseSize + (modSize or 0), "OUTLINE") end
        end
    end

    -- 2. VISUELS
    local opacity = KazolitusDB.opacity or 0.95
    Kz.SkinFrame(Kz.UI.Main, true)
    Kz.UI.Main:SetBackdropBorderColor(0,0,0,0)
    
    -- A) Fond de fenêtre : Image ou Noir
    local bgFile = KazolitusDB.windowBg or "MonFond" -- Valeur par défaut
    
    if bgFile == "None" then
        -- FOND NOIR
        Kz.UI.Main.bgImage:SetTexture(nil)
        Kz.UI.Main:SetBackdropColor(0.06, 0.06, 0.06, opacity)
    else
        -- IMAGE
        local bgPath = "Interface\\AddOns\\Kazolitus\\" .. bgFile .. ".tga"
        Kz.UI.Main.bgImage:SetTexture(bgPath)
        Kz.UI.Main.bgImage:SetAlpha(opacity)
        Kz.UI.Main:SetBackdropColor(0, 0, 0, 0)
    end
    
    -- B) Thème Personnage : Texture ou 3D
    local themeFile = KazolitusDB.theme or "Theme_Alleria"
    
    if themeFile == "Model3D" then
        -- MODE 3D
        if Kz.UI.PlayerImage then Kz.UI.PlayerImage:Hide() end
        if Kz.UI.PlayerModel then 
            Kz.UI.PlayerModel:Show()
            Kz.UI.PlayerModel:SetUnit("player")
            Kz.UI.PlayerModel:SetAlpha(opacity)
        end
    else
        -- MODE IMAGE
        if Kz.UI.PlayerModel then Kz.UI.PlayerModel:Hide() end
        if Kz.UI.PlayerImage then
            local themePath = "Interface\\AddOns\\Kazolitus\\" .. themeFile .. ".tga"
            Kz.UI.PlayerImage:SetTexture(themePath)
            Kz.UI.PlayerImage:Show()
        end
    end
    
    -- 3. Mise à jour des Textes
    local boris = LSM:Fetch("font", "Boris Black Bloxx") or "Fonts\\FRIZQT__.TTF"
    if Kz.UI.MainTitle then Kz.UI.MainTitle:SetFont(boris, 24, "OUTLINE") end
    
    local mk = "Equip"
    if Kz.UI.PlayerInfo then SetF(Kz.UI.PlayerInfo.iLvl, mk, 6); SetF(Kz.UI.PlayerInfo.MScore, mk, 2) end
    for _, group in pairs(Kz.UI.StatGroups or {}) do 
        if group.title then SetF(group.title, mk, 2) end
        if group.lines then for _, line in pairs(group.lines) do SetF(line.l, mk, 0); SetF(line.v, mk, 0) end end
    end
    for _, container in pairs(Kz.UI.Frames or {}) do 
        if container then SetF(container.txt, mk, 0); SetF(container.lvl, mk, -2); SetF(container.encht, mk, -2); SetF(container.dur, mk, -2) end 
    end

    mk = "Rep"
    if Kz.UI.RepGroups then 
        for _, g in pairs(Kz.UI.RepGroups) do 
            if g.title then SetF(g.title, mk, 2) end
            if g.lines then for _, l in pairs(g.lines) do SetF(l.name, mk, 0); SetF(l.val, mk, -2) end end 
        end 
    end

    mk = "Raid"
    if Kz.UI.RaidLines then for _, l in pairs(Kz.UI.RaidLines) do SetF(l.t, mk, 0); SetF(l.r, mk, 0) end end

    mk = "Cur"
    for _, f in pairs(Kz.UI.CurrencyFrames or {}) do if f.text then SetF(f.text, mk, 0) end end
    if Kz.UI.CurGroups then 
        for _, g in pairs(Kz.UI.CurGroups) do 
            if g.title then SetF(g.title, mk, 2) end
            if g.lines then for _, l in pairs(g.lines) do SetF(l.name, mk, 0); SetF(l.val, mk, 0) end end 
        end 
    end

    mk = "Social"
    if Kz.UI.SocialTitles then SetF(Kz.UI.SocialTitles.Friends, mk, 4); SetF(Kz.UI.SocialTitles.Guild, mk, 4) end
    if Kz.UI.SocialLines then for _, l in pairs(Kz.UI.SocialLines) do SetF(l.name, mk, 0); SetF(l.info, mk, -2) end end
    if Kz.UI.GuildLines then for _, l in pairs(Kz.UI.GuildLines) do SetF(l.name, mk, 0); SetF(l.info, mk, -2) end end

    mk = "Vault"
    if Kz.UI.Views.Vault and Kz.UI.Views.Vault.title then SetF(Kz.UI.Views.Vault.title, mk, 20) end
    if Kz.UI.VaultRows then
        for _, row in pairs(Kz.UI.VaultRows) do
            if row.title then SetF(row.title, mk, 14) end
            if row.desc then SetF(row.desc, mk, 4) end
            if row.cells then
                for _, cell in pairs(row.cells) do SetF(cell.status, mk, 8); SetF(cell.ilvl, mk, 2) end
            end
        end
    end

    if Kz.UI.Tabs then for _, btn in pairs(Kz.UI.Tabs) do if btn.text then btn.text:SetFont(boris, 12, "OUTLINE") end end end
    if Kz.Msq then if Kz.Msq.Slots then Kz.Msq.Slots:ReSkin() end; if Kz.Msq.Gems then Kz.Msq.Gems:ReSkin() end end
end

function Kz.CreateStatGroup(parent, title)
    local f = CreateFrame("Frame", nil, parent, "BackdropTemplate")
    f:SetSize(220, 100)
    Kz.SkinFrame(f)
    f.title = f:CreateFontString(nil, "OVERLAY", "GameFontNormal"); f.title:SetPoint("TOP", 0, -5); f.title:SetText("|cffffd700"..title.."|r")
    f.lines = {}
    if not Kz.UI.StatGroups then Kz.UI.StatGroups = {} end
    table.insert(Kz.UI.StatGroups, f)
    return f
end