local AddonName, Kz = ...
Kz.Cur = {}

function Kz.Cur.Init(parent)
    local scroll = CreateFrame("ScrollFrame", nil, parent, "UIPanelScrollFrameTemplate")
    scroll:SetPoint("TOPLEFT", 50, -30); scroll:SetPoint("BOTTOMRIGHT", -50, 30)
    
    local content = CreateFrame("Frame", nil, scroll); content:SetSize(1,1)
    scroll:SetScrollChild(content)
    
    Kz.UI.Views.Cur = scroll
    Kz.UI.Views.CurContent = content
    scroll:Hide()
end

function Kz.Cur.Update()
    if not Kz.UI.Views.Cur:IsShown() then return end
    
    local V = Kz.UI.Views.CurContent
    V:SetWidth(Kz.UI.Views.Cur:GetWidth())
    
    if Kz.UI.CurGroups then for _, g in pairs(Kz.UI.CurGroups) do g:Hide() end end
    local num = C_CurrencyInfo.GetCurrencyListSize(); local yMain = -10; local currentGroup, groupIndex, lineIndex = nil, 0, 0
    local function ToggleCur(index, val) C_CurrencyInfo.SetCurrencyBackpack(index, val); if Kz.CoreUpdate then Kz.CoreUpdate() end end
    
    for i=1, num do
        local info = C_CurrencyInfo.GetCurrencyListInfo(i)
        if info then
            if info.isHeader and not info.isChild then
                groupIndex = groupIndex + 1
                if not Kz.UI.CurGroups[groupIndex] then
                    local f = CreateFrame("Frame", nil, V, "BackdropTemplate"); f:SetSize(960, 50); Kz.SkinFrame(f)
                    f.title = f:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge"); f.title:SetPoint("TOP", 0, -5)
                    f.lines = {}; Kz.UI.CurGroups[groupIndex] = f
                end
                currentGroup = Kz.UI.CurGroups[groupIndex]; currentGroup:SetPoint("TOP", 0, yMain); currentGroup.title:SetText(info.name); currentGroup:Show()
                for _, l in pairs(currentGroup.lines) do l:Hide() end; lineIndex = 0
            elseif currentGroup and not info.isHeader then
                lineIndex = lineIndex + 1
                if not currentGroup.lines[lineIndex] then
                    local f = CreateFrame("Frame", nil, currentGroup); f:SetSize(450, 20)
                    f.chk = CreateFrame("CheckButton", nil, f, "ChatConfigCheckButtonTemplate"); f.chk:SetPoint("LEFT", 0, 0)
                    f.chk:SetScript("OnClick", function(self) ToggleCur(f.currencyIndex, self:GetChecked()) end)
                    f.icon = f:CreateTexture(nil, "ARTWORK"); f.icon:SetSize(16,16); f.icon:SetPoint("LEFT", f.chk, "RIGHT", 5, 0)
                    f.name = f:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); f.name:SetPoint("LEFT", f.icon, "RIGHT", 5, 0); f.name:SetWidth(180); f.name:SetWordWrap(false); f.name:SetJustifyH("LEFT")
                    f.val = f:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall"); f.val:SetPoint("RIGHT", 0, 0); f:EnableMouse(true)
                    f:SetScript("OnEnter", function(self) GameTooltip:SetOwner(self, "ANCHOR_RIGHT"); GameTooltip:SetCurrencyToken(self.currencyIndex); GameTooltip:Show() end); f:SetScript("OnLeave", function() GameTooltip:Hide() end)
                    currentGroup.lines[lineIndex] = f
                end
                local line = currentGroup.lines[lineIndex]
                local col = (lineIndex % 2 == 1) and 0 or 1; local row = math.ceil(lineIndex / 2); line:SetPoint("TOPLEFT", 20 + (col * 470), -30 - ((row - 1) * 20))
                line.currencyIndex = i; line.chk:SetChecked(info.isShowInBackpack)
                line.icon:SetTexture(info.iconFileID); line.val:SetText(Kz.FormatNumber(info.quantity)); line.name:SetText(info.name); line:Show()
                currentGroup:SetHeight((math.ceil(lineIndex / 2) * 20) + 40)
            end
        end
    end
    local runningY = -10; for i=1, groupIndex do local g = Kz.UI.CurGroups[i]; g:SetPoint("TOP", 0, runningY); runningY = runningY - g:GetHeight() - 10 end; V:SetHeight(math.abs(runningY))
end