local AddonName, Kz = ...
local LSM = LibStub("LibSharedMedia-3.0")

Kz.Opt = {}

local openDropdown = nil

-- Fonction utilitaire pour les menus déroulants
local function CreateCustomDropdown(parent, width, defaultText, onSelect)
    local f = CreateFrame("Button", nil, parent, "BackdropTemplate")
    f:SetSize(width, 25)
    Kz.SkinFrame(f)
    
    f.Text = f:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
    f.Text:SetPoint("LEFT", 10, 0); f.Text:SetPoint("RIGHT", -25, 0)
    f.Text:SetJustifyH("LEFT"); f.Text:SetText(defaultText)
    
    local btn = CreateFrame("Button", nil, f)
    btn:SetSize(20, 20); btn:SetPoint("RIGHT", -2, 0)
    btn:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Up")
    btn:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Down")
    
    local listFrame = CreateFrame("Frame", nil, f, "BackdropTemplate")
    listFrame:SetPoint("TOPLEFT", f, "BOTTOMLEFT", 0, -2)
    listFrame:SetWidth(width); listFrame:SetFrameStrata("DIALOG")
    Kz.SkinFrame(listFrame); listFrame:Hide()
    
    local scroll = CreateFrame("ScrollFrame", nil, listFrame, "UIPanelScrollFrameTemplate")
    scroll:SetPoint("TOPLEFT", 5, -5); scroll:SetPoint("BOTTOMRIGHT", -25, 5)
    
    local content = CreateFrame("Frame", nil, scroll)
    content:SetSize(width - 30, 10); scroll:SetScrollChild(content)
    
    f.List = listFrame; f.Content = content
    
    local function Toggle()
        if listFrame:IsShown() then listFrame:Hide() else 
            if openDropdown and openDropdown ~= listFrame then openDropdown:Hide() end
            listFrame:Show(); openDropdown = listFrame
        end
    end
    f:SetScript("OnClick", Toggle); btn:SetScript("OnClick", Toggle)
    return f
end

function Kz.Opt.Init(parent)
    -- CRUCIAL : On crée une fenêtre UIParent (Flottante), pas enfant de "parent"
    local frame = CreateFrame("Frame", "KazolitusOptions", UIParent, "BackdropTemplate")
    frame:SetSize(350, 500)
    frame:SetPoint("CENTER", 0, 0)
    frame:SetFrameStrata("HIGH") -- Au-dessus des autres fenêtres
    frame:EnableMouse(true)
    frame:SetMovable(true)
    frame:RegisterForDrag("LeftButton")
    frame:SetScript("OnDragStart", frame.StartMoving)
    frame:SetScript("OnDragStop", frame.StopMovingOrSizing)
    
    Kz.SkinFrame(frame)
    frame:SetBackdropColor(0.1, 0.1, 0.1, 0.95)
    
    local title = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
    title:SetPoint("TOP", 0, -15); title:SetText("Kazolitus - Options")
    
    local close = CreateFrame("Button", nil, frame, "UIPanelCloseButton")
    close:SetPoint("TOPRIGHT", -5, -5); close:SetScript("OnClick", function() frame:Hide() end)
    
    -- 1. OPACITE
    local sliderOp = CreateFrame("Slider", "KzOpSlider", frame, "OptionsSliderTemplate")
    sliderOp:SetPoint("TOPLEFT", 30, -50); sliderOp:SetWidth(290)
    sliderOp:SetMinMaxValues(0, 1); sliderOp:SetValueStep(0.05); sliderOp:SetObeyStepOnDrag(true)
    _G[sliderOp:GetName() .. "Low"]:SetText("0%"); _G[sliderOp:GetName() .. "High"]:SetText("100%")
    _G[sliderOp:GetName() .. "Text"]:SetText("Opacité Interface")
    sliderOp:SetScript("OnValueChanged", function(self, value) KazolitusDB.opacity = value; if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end end)
    sliderOp:SetValue(KazolitusDB.opacity or 0.95)
    
    -- 2. FOND DE FENETRE
    local lblBg = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
    lblBg:SetPoint("TOPLEFT", sliderOp, "BOTTOMLEFT", 0, -25); lblBg:SetText("Arrière-plan de la fenêtre")
    
    local bgOptions = {
        {name = "Noir", file = "None"},
        {name = "Paisible", file = "Paisible"},
        {name = "Ambiance Obscur", file = "Ambiance Obscur"}
    }
    
    local currentBgName = "Noir"
    if KazolitusDB.windowBg == "MonFond" then currentBgName = "Classique (MonFond)"
    elseif KazolitusDB.windowBg == "MonFond1" then currentBgName = "Alternatif (MonFond1)" end
    
    local dropBg = CreateCustomDropdown(frame, 200, currentBgName)
    dropBg:SetPoint("TOPLEFT", lblBg, "BOTTOMLEFT", 0, -10)
    
    local bY = 0
    for _, bgData in ipairs(bgOptions) do
        local b = CreateFrame("Button", nil, dropBg.Content); b:SetSize(170, 20); b:SetPoint("TOPLEFT", 0, bY)
        local t = b:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); t:SetPoint("LEFT", 5, 0); t:SetText(bgData.name)
        b:SetScript("OnEnter", function() t:SetTextColor(1,1,0) end); b:SetScript("OnLeave", function() t:SetTextColor(1,1,1) end)
        b:SetScript("OnClick", function()
            KazolitusDB.windowBg = bgData.file
            dropBg.Text:SetText(bgData.name); dropBg.List:Hide()
            if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end
        end)
        bY = bY - 20
    end
    dropBg.Content:SetHeight(math.abs(bY)); dropBg.List:SetHeight(math.abs(bY) + 10)

    -- 3. THEME PERSONNAGE
    local lblTheme = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
    lblTheme:SetPoint("TOPLEFT", dropBg, "BOTTOMLEFT", 0, -25); lblTheme:SetText("Visuel Personnage")
    
    local dropTheme = CreateCustomDropdown(frame, 200, KazolitusDB.themeName or "Modèle 3D")
    dropTheme:SetPoint("TOPLEFT", lblTheme, "BOTTOMLEFT", 0, -10)
    
    local tY = 0
    -- Option 3D
    local b3d = CreateFrame("Button", nil, dropTheme.Content); b3d:SetSize(170, 20); b3d:SetPoint("TOPLEFT", 0, tY)
    local t3d = b3d:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); t3d:SetPoint("LEFT", 5, 0); t3d:SetText("Modèle 3D (Natif)")
    b3d:SetScript("OnEnter", function() t3d:SetTextColor(1,1,0) end); b3d:SetScript("OnLeave", function() t3d:SetTextColor(1,1,1) end)
    b3d:SetScript("OnClick", function()
        KazolitusDB.theme = "Model3D"
        KazolitusDB.themeName = "Modèle 3D (Natif)"
        dropTheme.Text:SetText("Modèle 3D (Natif)"); dropTheme.List:Hide()
        if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end
    end)
    tY = tY - 20
    
    -- Options Images
    if Kz.ThemeList then
        for i, tData in ipairs(Kz.ThemeList) do
            local b = CreateFrame("Button", nil, dropTheme.Content); b:SetSize(170, 20); b:SetPoint("TOPLEFT", 0, tY)
            local t = b:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); t:SetPoint("LEFT", 5, 0); t:SetText(tData.name)
            b:SetScript("OnEnter", function() t:SetTextColor(1,1,0) end); b:SetScript("OnLeave", function() t:SetTextColor(1,1,1) end)
            b:SetScript("OnClick", function()
                KazolitusDB.theme = tData.file
                KazolitusDB.themeName = tData.name
                dropTheme.Text:SetText(tData.name); dropTheme.List:Hide()
                if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end
            end)
            tY = tY - 20
        end
    end
    dropTheme.Content:SetHeight(math.abs(tY)); dropTheme.List:SetHeight(math.min(math.abs(tY) + 10, 180))
    
    -- 4. POLICES & 5. TAILLE
    local lblFont = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal"); lblFont:SetPoint("TOPLEFT", dropTheme, "BOTTOMLEFT", 0, -25); lblFont:SetText("Police d'écriture")
    local dropFont = CreateCustomDropdown(frame, 200, KazolitusDB.font or "Boris Black Bloxx"); dropFont:SetPoint("TOPLEFT", lblFont, "BOTTOMLEFT", 0, -10)
    local fontList = LSM:List("font"); local fY = 0
    for _, fName in ipairs(fontList) do
        local b = CreateFrame("Button", nil, dropFont.Content); b:SetSize(170, 20); b:SetPoint("TOPLEFT", 0, fY)
        local t = b:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); t:SetPoint("LEFT", 5, 0); t:SetText(fName)
        local p = LSM:Fetch("font", fName); if p then t:SetFont(p, 12) end
        b:SetScript("OnEnter", function() t:SetTextColor(1,1,0) end); b:SetScript("OnLeave", function() t:SetTextColor(1,1,1) end)
        b:SetScript("OnClick", function() KazolitusDB.font = fName; dropFont.Text:SetText(fName); dropFont.List:Hide(); if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end end)
        fY = fY - 20
    end
    dropFont.Content:SetHeight(math.abs(fY)); dropFont.List:SetHeight(180)
    
    local sliderSize = CreateFrame("Slider", "KzSizeSlider", frame, "OptionsSliderTemplate")
    sliderSize:SetPoint("TOPLEFT", dropFont, "BOTTOMLEFT", 0, -35); sliderSize:SetWidth(290)
    sliderSize:SetMinMaxValues(8, 32); sliderSize:SetValueStep(1); sliderSize:SetObeyStepOnDrag(true)
    _G[sliderSize:GetName() .. "Low"]:SetText("8"); _G[sliderSize:GetName() .. "High"]:SetText("32"); _G[sliderSize:GetName() .. "Text"]:SetText("Taille Police Global")
    sliderSize:SetScript("OnValueChanged", function(self, value) KazolitusDB.fontSize = value; if Kz.UpdateGlobalVisuals then Kz.UpdateGlobalVisuals() end end)
    sliderSize:SetValue(KazolitusDB.fontSize or 12)
    
    frame:Hide()
    Kz.UI.Views.OptionsWindow = frame
end

function Kz.Opt.Toggle() 
    local w = Kz.UI.Views.OptionsWindow; 
    if not w then return end; 
    if w:IsShown() then w:Hide() else w:Show() end 
end