local AddonName, Kz = ...
Kz.Raid = {}

function Kz.Raid.Init(parent)
    local view = CreateFrame("ScrollFrame", nil, parent, "UIPanelScrollFrameTemplate")
    -- CORRECTION ICI
    view:SetAllPoints(parent)
    Kz.UI.Views.Raid = view
    
    local child = CreateFrame("Frame", nil, view)
    child:SetSize(800, 1000)
    view:SetScrollChild(child)
    Kz.UI.RaidContent = child
    
    Kz.UI.RaidLines = {}
    view:Hide()
end

function Kz.Raid.Update()
    if not Kz.UI.Views.Raid:IsShown() then return end
    if not Kz.UI.RaidLines then Kz.UI.RaidLines = {} end
    for _, l in pairs(Kz.UI.RaidLines) do l:Hide() end
    
    local y = -20 -- Petite marge interne en haut
    local saved = GetSavedInstanceInfo and GetNumSavedInstances() or 0
    local hasRaid = false
    
    for i = 1, saved do
        local name, _, reset, _, locked, _, _, isRaid, _, diffName, numEncounters, encounterProgress = GetSavedInstanceInfo(i)
        if isRaid and (locked or reset > 0) then
            hasRaid = true
            local line = Kz.UI.RaidLines[i]
            if not line then
                local f = CreateFrame("Frame", nil, Kz.UI.RaidContent, "BackdropTemplate")
                f:SetSize(600, 40)
                Kz.SkinFrame(f)
                f.t = f:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge"); f.t:SetPoint("LEFT", 10, 0)
                f.r = f:CreateFontString(nil, "OVERLAY", "GameFontHighlight"); f.r:SetPoint("RIGHT", -10, 0)
                Kz.UI.RaidLines[i] = f; line = f
            end
            line:SetPoint("TOP", 0, y)
            line:Show()
            local color = (encounterProgress == numEncounters) and "|cffff0000" or "|cff00ff00"
            line.t:SetText(name .. " (" .. diffName .. ")")
            line.r:SetText(color .. encounterProgress .. "/" .. numEncounters .. "|r Boss")
            y = y - 45
        end
    end
    
    if not hasRaid then
        local line = Kz.UI.RaidLines[1]
        if not line then
             local f = CreateFrame("Frame", nil, Kz.UI.RaidContent)
             f:SetSize(600,40); f.t = f:CreateFontString(nil,"OVERLAY","GameFontNormal"); f.t:SetPoint("CENTER")
             f.r = f:CreateFontString(nil,"OVERLAY","GameFontNormal"); f.r:Hide()
             Kz.UI.RaidLines[1] = f; line = f
        end
        line:Show(); line:SetPoint("TOP", 0, -50)
        line.t:SetText("Aucun raid sauvegardé cette semaine.")
    end
end