local AddonName, Kz = ...
Kz.Rep = {}

function Kz.Rep.Init(parent)
    local scroll = CreateFrame("ScrollFrame", nil, parent, "UIPanelScrollFrameTemplate")
    scroll:SetPoint("TOPLEFT", 50, -30); scroll:SetPoint("BOTTOMRIGHT", -50, 30)
    
    local content = CreateFrame("Frame", nil, scroll); content:SetSize(1,1)
    scroll:SetScrollChild(content)
    
    Kz.UI.Views.Rep = scroll
    Kz.UI.Views.RepContent = content
    scroll:Hide()
end

function Kz.Rep.Update()
    local view = Kz.UI.Views.Rep
    if not view:IsShown() then return end
    
    local V = Kz.UI.Views.RepContent
    V:SetWidth(view:GetWidth())
    
    if Kz.UI.RepGroups then for _, g in pairs(Kz.UI.RepGroups) do g:Hide() end end
    
    local num = C_Reputation.GetNumFactions(); local yMain = -10; local currentGroup, groupIndex, lineIndex = nil, 0, 0
    
    for i=1, num do
        local data = C_Reputation.GetFactionDataByIndex(i)
        if data then
            if data.isHeader and not data.isChild then
                groupIndex = groupIndex + 1
                if not Kz.UI.RepGroups[groupIndex] then
                    local f = CreateFrame("Frame", nil, V, "BackdropTemplate"); f:SetSize(960, 50); Kz.SkinFrame(f)
                    f.title = f:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge"); f.title:SetPoint("TOP", 0, -5)
                    f.lines = {}; Kz.UI.RepGroups[groupIndex] = f
                end
                currentGroup = Kz.UI.RepGroups[groupIndex]; currentGroup:SetPoint("TOP", 0, yMain); currentGroup.title:SetText(data.name); currentGroup:Show()
                for _, l in pairs(currentGroup.lines) do l:Hide() end; lineIndex = 0
            elseif not data.isHeader and currentGroup then
                lineIndex = lineIndex + 1
                if not currentGroup.lines[lineIndex] then
                    local f = CreateFrame("StatusBar", nil, currentGroup); f:SetSize(450, 16); f:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar"); f:GetStatusBarTexture():SetHorizTile(false); f:SetMinMaxValues(0, 100)
                    f.bg = f:CreateTexture(nil, "BACKGROUND"); f.bg:SetTexture("Interface\\TargetingFrame\\UI-StatusBar"); f.bg:SetAllPoints(true); f.bg:SetVertexColor(0.2, 0.2, 0.2, 0.5)
                    f.name = f:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall"); f.name:SetPoint("LEFT", 5, 0)
                    f.val = f:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall"); f.val:SetPoint("RIGHT", -5, 0)
                    currentGroup.lines[lineIndex] = f
                end
                local bar = currentGroup.lines[lineIndex]; local col = (lineIndex % 2 == 1) and 0 or 1; local row = math.ceil(lineIndex / 2)
                bar:SetPoint("TOPLEFT", 20 + (col * 470), -30 - ((row - 1) * 20))
                local barMin, barMax, barVal = data.currentReactionThreshold, data.nextReactionThreshold, data.currentStanding
                local percent = 0; if barMax > barMin then percent = ((barVal - barMin) / (barMax - barMin)) * 100 end; if percent > 100 then percent = 100 end
                bar:SetValue(percent); local r, g, b = Kz.GetGradientColor(percent); bar:SetStatusBarColor(r, g, b)
                bar.name:SetText(data.name); bar.val:SetText(string.format("%s (%.0f%%)", _G["FACTION_STANDING_LABEL"..(data.reaction or 4)] or "Neutre", percent))
                bar:Show(); currentGroup:SetHeight((math.ceil(lineIndex / 2) * 20) + 40)
            end
        end
    end
    local runningY = -10; for i=1, groupIndex do local g = Kz.UI.RepGroups[i]; g:SetPoint("TOP", 0, runningY); runningY = runningY - g:GetHeight() - 10 end; V:SetHeight(math.abs(runningY))
end