local AddonName, Kz = ...
Kz.Social = {}

function Kz.Social.Init(parent)
    local scrollF = CreateFrame("ScrollFrame", nil, parent, "UIPanelScrollFrameTemplate")
    scrollF:SetPoint("TOPLEFT", 50, -50); scrollF:SetPoint("BOTTOMLEFT", 50, 30); scrollF:SetPoint("RIGHT", parent, "CENTER", -10, 0)
    local contentF = CreateFrame("Frame", nil, scrollF); contentF:SetSize(1,1); scrollF:SetScrollChild(contentF)
    
    local scrollG = CreateFrame("ScrollFrame", nil, parent, "UIPanelScrollFrameTemplate")
    scrollG:SetPoint("TOPRIGHT", -50, -50); scrollG:SetPoint("BOTTOMRIGHT", -50, 30); scrollG:SetPoint("LEFT", parent, "CENTER", 10, 0)
    local contentG = CreateFrame("Frame", nil, scrollG); contentG:SetSize(1,1); scrollG:SetScrollChild(contentG)

    Kz.UI.Views.Social = scrollF
    Kz.UI.Views.SocialContent = contentF
    Kz.UI.Views.Guild = scrollG
    Kz.UI.Views.GuildContent = contentG
    
    Kz.UI.SocialTitles = { Friends = parent:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge"), Guild = parent:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge") }
    Kz.UI.SocialTitles.Friends:SetPoint("BOTTOMLEFT", scrollF, "TOPLEFT", 0, 10); Kz.UI.SocialTitles.Friends:SetText("AMIS")
    Kz.UI.SocialTitles.Guild:SetPoint("BOTTOMLEFT", scrollG, "TOPLEFT", 0, 10); Kz.UI.SocialTitles.Guild:SetText("GUILDE")
    
    scrollF:Hide(); scrollG:Hide(); Kz.UI.SocialTitles.Friends:Hide(); Kz.UI.SocialTitles.Guild:Hide()
end

function Kz.Social.Update()
    local V = Kz.UI.Views
    if not V.Social:IsShown() then return end
    
    Kz.UI.SocialTitles.Friends:Show(); Kz.UI.SocialTitles.Guild:Show()
    for _, l in pairs(Kz.UI.SocialLines) do l:Hide() end
    for _, l in pairs(Kz.UI.GuildLines) do l:Hide() end
    
    local function GetLine(idx, parent, list) 
        if not list[idx] then 
            local f = CreateFrame("Button", nil, parent, "BackdropTemplate"); f:SetSize(620, 25); Kz.SkinFrame(f)
            f.name = f:CreateFontString(nil, "OVERLAY", "GameFontHighlight"); f.name:SetPoint("LEFT", 5, 0)
            f.info = f:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall"); f.info:SetPoint("RIGHT", -5, 0)
            list[idx] = f
        end
        return list[idx]
    end
    
    -- AMIS
    local offset = 0
    local numBNet = BNGetNumFriends()
    for i=1, numBNet do 
        local info = C_BattleNet.GetFriendAccountInfo(i)
        if info and info.gameAccountInfo.isOnline then
            offset = offset + 1
            local line = GetLine(offset, V.SocialContent, Kz.UI.SocialLines)
            line:SetPoint("TOPLEFT", 10, -((offset-1)*25))
            local nameText = info.accountName or info.battleTag
            if info.gameAccountInfo.clientProgram == BNET_CLIENT_WOW and info.gameAccountInfo.characterName then
                 nameText = nameText .. " (" .. info.gameAccountInfo.characterName .. ")"
            end
            line.name:SetText(nameText)
            line.info:SetText(info.gameAccountInfo.areaName or info.gameAccountInfo.clientProgram)
            line:Show()
        end
    end
    V.SocialContent:SetHeight(offset * 25)

    -- GUILDE
    local gOffset = 0
    if IsInGuild() then
        local numGuild = GetNumGuildMembers()
        for i=1, numGuild do
            local name, _, _, _, _, zone, _, _, online, _, classFileName = GetGuildRosterInfo(i)
            if online then
                gOffset = gOffset + 1
                local line = GetLine(gOffset, V.GuildContent, Kz.UI.GuildLines)
                line:SetPoint("TOPLEFT", 10, -((gOffset-1)*25))
                local c = C_ClassColor.GetClassColor(classFileName) or CreateColor(1,1,1,1)
                line.name:SetText("|c"..c:GenerateHexColor()..(strsplit("-", name)).."|r")
                line.info:SetText(zone or "Inconnu")
                line:Show()
            end
        end
    end
    V.GuildContent:SetHeight(gOffset * 25)
end