local AddonName, Kz = ...
Kz.Vault = {}

-- CHEMINS DES TEXTURES
local TEX_LOCKED = "Interface\\AddOns\\Kazolitus\\Vault_Locked.tga"
local TEX_READY = "Interface\\AddOns\\Kazolitus\\Vault_Ready.tga"

local ROWS = {
    { type = Enum.WeeklyRewardChestThresholdType.Raid, name = "RAIDS", icon = "Interface\\Icons\\Achievement_Raid_PrimalIncarnates", desc = "Vaincre des boss de raid pour débloquer des objets de la Grande Chambre-forte." },
    { type = Enum.WeeklyRewardChestThresholdType.Activities, name = "DONJONS", icon = "Interface\\Icons\\Achievement_Dungeon_Deeps", desc = "Terminer des donjons Héroïques, Mythiques ou des donjons de pierre mythique." },
    { type = Enum.WeeklyRewardChestThresholdType.World, name = "MONDE", icon = "Interface\\Icons\\Achievement_WorldEvent_SolarCelebration", desc = "Terminer des activités de monde ou des Gouffres pour obtenir des récompenses." }
}

-- --- FONCTION D'INFOBULLE PERSONNALISÉE (PLAN B) ---
-- Utilisée si l'infobulle officielle ne peut pas être chargée
local function ShowCustomVaultTooltip(cell)
    local info = cell.info
    if not info then return end
    
    GameTooltip:SetOwner(cell, "ANCHOR_RIGHT")
    GameTooltip:ClearLines()
    
    if cell.unlocked then
        -- CAS DÉBLOQUÉ
        GameTooltip:SetText("Récompense débloquée", 0, 1, 0)
        GameTooltip:AddLine("Vous pourrez choisir une récompense dans cette case la semaine prochaine.", 1, 1, 1, true)
        
        -- Tentative d'affichage de l'item exemple
        local link = C_WeeklyRewards.GetExampleRewardItemHyperlinks(info.id)
        if link then
            GameTooltip:AddLine(" ")
            GameTooltip:AddLine("Exemple de récompense :", 1, 0.82, 0)
            GameTooltip:AddHyperlink(link)
            
            local ilvl = GetDetailedItemLevelInfo(link)
            if ilvl then
                GameTooltip:AddLine("Niveau d'objet : " .. ilvl, 1, 1, 1)
            end
        else
            GameTooltip:AddLine("Niveau de difficulté : " .. info.level, 1, 1, 1)
        end
    else
        -- CAS VERROUILLÉ (Style Blizzard)
        GameTooltip:SetText("Débloquer la récompense", 1, 0.82, 0) -- Titre Doré
        
        local diff = info.threshold - info.progress
        if diff < 0 then diff = 0 end
        
        -- Définition du texte selon le type
        local text = ""
        if info.type == Enum.WeeklyRewardChestThresholdType.Raid then
            text = string.format("Battez encore %d boss de raid cette semaine.", diff)
        elseif info.type == Enum.WeeklyRewardChestThresholdType.Activities then
            text = string.format("Terminez encore %d donjons (Héroïque, Mythique ou Clé) cette semaine.", diff)
        elseif info.type == Enum.WeeklyRewardChestThresholdType.World then
            text = string.format("Terminez encore %d Gouffres ou activités de monde cette semaine.", diff)
        end
        
        GameTooltip:AddLine(text, 1, 1, 1, true)
        
        GameTooltip:AddLine(" ")
        if info.progress > 0 then
            GameTooltip:AddDoubleLine("Progression :", string.format("%d / %d", info.progress, info.threshold), 1, 1, 1, 1, 1, 1)
        else
            GameTooltip:AddLine("Commencez cette activité pour progresser.", 0.7, 0.7, 0.7)
        end
        
        -- Info sur le niveau
        GameTooltip:AddLine(" ")
        GameTooltip:AddLine("Le niveau de la récompense dépendra de la difficulté des activités terminées.", 0.7, 0.7, 0.7, true)
    end
    
    GameTooltip:Show()
end

function Kz.Vault.Init(parent)
    -- On essaie de charger l'addon Blizzard, mais on ne compte pas dessus à 100%
    if not C_AddOns.IsAddOnLoaded("Blizzard_WeeklyRewards") then
        pcall(C_AddOns.LoadAddOn, "Blizzard_WeeklyRewards")
    end

    local view = CreateFrame("Frame", nil, parent)
    view:SetAllPoints()
    Kz.UI.Views.Vault = view
    
    local title = view:CreateFontString(nil, "OVERLAY", "GameFontNormalHuge")
    title:SetPoint("TOP", 0, -25) 
    title:SetText("GRANDE CHAMBRE-FORTE")
    view.title = title 
    
    Kz.UI.VaultRows = {}
    
    local prevRow = nil
    for i, data in ipairs(ROWS) do
        local row = CreateFrame("Frame", nil, view, "BackdropTemplate")
        row:SetSize(1300, 200) 
        Kz.SkinFrame(row)
        
        if i == 1 then row:SetPoint("TOP", 0, -60) else row:SetPoint("TOP", prevRow, "BOTTOM", 0, -10) end
        
        -- Icône
        row.icon = row:CreateTexture(nil, "ARTWORK")
        row.icon:SetSize(100, 100); row.icon:SetPoint("LEFT", 10, -30)
        row.icon:SetTexture(data.icon); Kz.SkinIcon(row.icon); row.icon:SetAlpha(0.2)
        
        -- Textes
        row.title = row:CreateFontString(nil, "OVERLAY", "GameFontNormalHuge")
        row.title:SetPoint("TOPLEFT", row, "TOPLEFT", 20, -15); row.title:SetText(data.name)
        
        row.desc = row:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
        row.desc:SetPoint("TOPLEFT", row.title, "BOTTOMLEFT", 0, -10); row.desc:SetWidth(280)
        row.desc:SetJustifyH("LEFT"); row.desc:SetJustifyV("TOP"); row.desc:SetWordWrap(true); row.desc:SetText(data.desc)
        
        row.cells = {}
        for j = 1, 3 do
            local cell = CreateFrame("Frame", nil, row, "BackdropTemplate")
            cell:SetSize(300, 160)
            cell:SetPoint("RIGHT", -20 - ((3-j)*310), 0)
            
            Kz.SkinFrame(cell)
            cell:SetBackdropColor(0,0,0,0.5)
            
            cell.tex = cell:CreateTexture(nil, "BACKGROUND"); cell.tex:SetAllPoints(); cell.tex:SetTexCoord(0, 1, 0, 1); cell.tex:SetAlpha(0.9)
            cell.status = cell:CreateFontString(nil, "OVERLAY", "GameFontNormalHuge"); cell.status:SetPoint("CENTER", 0, 15); cell.status:SetShadowOffset(2, -2)
            cell.ilvl = cell:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge"); cell.ilvl:SetPoint("TOP", cell.status, "BOTTOM", 0, -10); cell.ilvl:SetShadowOffset(1, -1)
            
            -- GESTION INTELLIGENTE DE L'INFOBULLE
            cell:EnableMouse(true)
            cell:SetScript("OnEnter", function(self)
                -- 1. On essaie d'utiliser le Mixin officiel de Blizzard
                if self.info and _G.WeeklyRewardActivityMixin then
                    -- On injecte les données comme Blizzard l'attend parfois
                    self.type = self.info.type
                    self.index = self.info.index
                    
                    -- Appel sécurisé à la fonction officielle
                    local success = pcall(_G.WeeklyRewardActivityMixin.OnEnter, self)
                    if success then return end -- Si ça marche, on s'arrête là
                end
                
                -- 2. PLAN B : Si l'officiel a échoué ou est absent, on utilise notre fonction
                ShowCustomVaultTooltip(self)
            end)
            
            cell:SetScript("OnLeave", function(self)
                if _G.WeeklyRewardActivityMixin and _G.WeeklyRewardActivityMixin.OnLeave then
                    pcall(_G.WeeklyRewardActivityMixin.OnLeave, self)
                end
                GameTooltip:Hide()
            end)
            
            row.cells[j] = cell
        end
        
        Kz.UI.VaultRows[data.type] = row
        prevRow = row
    end
    view:Hide()
end

function Kz.Vault.Update()
    if not Kz.UI.Views.Vault:IsShown() then return end
    
    for _, data in ipairs(ROWS) do
        local typeID = data.type
        local row = Kz.UI.VaultRows[typeID]
        local activities = C_WeeklyRewards.GetActivities(typeID)
        table.sort(activities, function(a, b) return a.index < b.index end)
        
        for i, info in ipairs(activities) do
            local cell = row.cells[i]
            if cell then
                cell.info = info -- Stockage des données pour l'infobulle
                local p, t = info.progress, info.threshold
                
                if p >= t then
                    -- DÉBLOQUÉ
                    cell.unlocked = true
                    cell.tex:SetTexture(TEX_READY) 
                    cell.status:SetText("|cff00ff00Terminé|r")
                    cell:SetBackdropBorderColor(0, 1, 0, 1)
                    
                    local levelText = "Niveau " .. info.level
                    local itemLink = C_WeeklyRewards.GetExampleRewardItemHyperlinks(info.id)
                    if itemLink then
                        local ilvl = GetDetailedItemLevelInfo(itemLink)
                        if ilvl then levelText = "|cffffffff" .. ilvl .. "|r" end
                    end
                    cell.ilvl:SetText(levelText)
                else
                    -- VERROUILLÉ
                    cell.unlocked = false
                    cell.tex:SetTexture(TEX_LOCKED)
                    cell.status:SetText(string.format("%d / %d", p, t))
                    cell:SetBackdropBorderColor(0.5, 0.5, 0.5, 0.5)
                    cell.ilvl:SetText("Verrouillé")
                end
            end
        end
    end
end