local AddonName, Kz = ...

-- Helper pour détecter les valeurs secrètes
local function IsSecret(val)
    if issecretvalue and issecretvalue(val) then return true end
    return false
end

-- Helper pour afficher le titre style Blizzard
local function AddBlizzLine(title, value, desc)
    GameTooltip:AddDoubleLine(title, value, 1, 1, 1, 1, 1, 1) -- Titre Blanc
    if desc then
        GameTooltip:AddLine(desc, 1, 0.82, 0, true) -- Description Dorée
    end
end

function Kz.ShowStatTooltip(self) 
    GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
    GameTooltip:ClearLines()
    
    local stat = self.stat
    local id = self.id
    
    -- --- 1. ATTRIBUTS PRIMAIRES ---
    if self.type == "ATTRIB" then
        local statID = tonumber(id)
        if not statID then return end 

        -- Récupération : Valeur Totale, Bonus Positif, Bonus Négatif
        local _, statVal, posBuff, negBuff = UnitStat("player", statID)
        
        -- Protection 12.0 : Eviter le crash sur calcul secret
        if IsSecret(statVal) or IsSecret(posBuff) or IsSecret(negBuff) then
             GameTooltip:AddDoubleLine(self.label, "***", 1, 1, 1, 0.5, 0.5, 0.5)
             GameTooltip:AddLine("Donnée masquée par l'interface Blizzard (Combat)", 1, 0, 0)
             GameTooltip:Show()
             return
        end
        
        -- Calculs (Sécurisés maintenant)
        local totalBonus = (posBuff or 0) + (negBuff or 0)
        local base = statVal - totalBonus
        local name = self.label
        
        -- Ligne 1 : Titre et Valeur Totale
        GameTooltip:AddDoubleLine(name, Kz.FormatNumber(statVal), 1, 1, 1, 1, 1, 1)
        
        -- Ligne 2 : Base + Bonus (Coloration dynamique)
        local bonusText = ""
        if totalBonus > 0 then
            bonusText = "|cff00ff00+" .. Kz.FormatNumber(totalBonus) .. "|r" -- Vert
        elseif totalBonus < 0 then
            bonusText = "|cffff0000" .. Kz.FormatNumber(totalBonus) .. "|r"  -- Rouge
        else
            bonusText = "|cff808080+0|r" -- Gris si 0
        end
        
        GameTooltip:AddLine(string.format("Base: %s %s", Kz.FormatNumber(base), bonusText), 1, 1, 1)
        
        -- Ligne 3 : Description
        local desc = "Augmente la puissance de votre personnage."
        if statID == 1 then desc = "Augmente la puissance d'attaque et les dégâts de vos compétences."
        elseif statID == 2 then desc = "Augmente la puissance d'attaque et les chances de coup critique."
        elseif statID == 3 then desc = "Augmente vos points de vie maximum."
        elseif statID == 4 then desc = "Augmente la puissance des sorts et les dégâts de vos capacités." end
        
        GameTooltip:AddLine(desc, 1, 0.82, 0, true)
    
    -- --- 2. STATS SECONDAIRES ---
    elseif stat == "CRIT" then
        local chance = GetCritChance()
        local rating = GetCombatRating(CR_CRIT_MELEE)
        AddBlizzLine("Coups critiques", string.format("%.2f%%", chance or 0), string.format("Score: %s\nAugmente vos chances d'infliger des dégâts ou des soins accrus.", Kz.FormatNumber(rating)))
        
    elseif stat == "HASTE" then
        local haste = GetHaste()
        local rating = GetCombatRating(CR_HASTE_MELEE)
        AddBlizzLine("Hâte", string.format("%.2f%%", haste or 0), string.format("Score: %s\nAugmente la vitesse d'attaque et d'incantation de sorts.", Kz.FormatNumber(rating)))
        
    elseif stat == "MASTERY" then
        local mastery = GetMasteryEffect()
        local rating = GetCombatRating(CR_MASTERY)
        
        local masteryDesc = "Augmente l'efficacité de votre maîtrise."
        local specID = GetSpecialization()
        if specID then
            local masterySpellID = GetSpecializationMasterySpells(specID)
            if masterySpellID then
                local info = C_Spell.GetSpellDescription(masterySpellID)
                if info and info ~= "" then masteryDesc = info end
            end
        end
        AddBlizzLine("Maîtrise", string.format("%.2f%%", mastery or 0), string.format("Score: %s\n%s", Kz.FormatNumber(rating), masteryDesc))
        
    elseif stat == "VERSATILITY" then
        local vers = GetCombatRatingBonus(CR_VERSATILITY_DAMAGE_DONE) + GetVersatilityBonus(CR_VERSATILITY_DAMAGE_DONE)
        local rating = GetCombatRating(CR_VERSATILITY_DAMAGE_DONE)
        local reduce = GetCombatRatingBonus(CR_VERSATILITY_DAMAGE_TAKEN) + GetVersatilityBonus(CR_VERSATILITY_DAMAGE_TAKEN)
        AddBlizzLine("Polyvalence", string.format("%.2f%%", vers or 0), string.format("Score: %s\nAugmente les dégâts/soins de %.2f%% et réduit les dégâts subis de %.2f%%.", Kz.FormatNumber(rating), vers, reduce))
        
    elseif stat == "LIFESTEAL" then
        local lifesteal = GetLifesteal()
        local rating = GetCombatRating(CR_LIFESTEAL)
        AddBlizzLine("Ponction", string.format("%.2f%%", lifesteal or 0), string.format("Score: %s\nVous rend une partie des dégâts et soins infligés sous forme de points de vie.", Kz.FormatNumber(rating)))
    
    -- --- 3. DÉFENSE & AUTRES ---
    elseif stat == "ARMOR" then
        local _, effectiveArmor = UnitArmor("player")
        AddBlizzLine("Armure", Kz.FormatNumber(effectiveArmor), "Réduit les dégâts physiques subis.")
        
    elseif stat == "DODGE" then
        AddBlizzLine("Esquive", string.format("%.2f%%", GetDodgeChance() or 0), "Score: "..Kz.FormatNumber(GetCombatRating(CR_DODGE)).."\nChances d'esquiver les attaques de mêlée.")
        
    elseif stat == "PARRY" then
        AddBlizzLine("Parade", string.format("%.2f%%", GetParryChance() or 0), "Score: "..Kz.FormatNumber(GetCombatRating(CR_PARRY)).."\nChances de parer les attaques de mêlée.")
        
    elseif stat == "BLOCK" then
        AddBlizzLine("Blocage", string.format("%.2f%%", GetBlockChance() or 0), "Score: "..Kz.FormatNumber(GetCombatRating(CR_BLOCK)).."\nChances de bloquer les attaques de mêlée.")
        
    else
        GameTooltip:SetText(self.label)
        if self.desc then GameTooltip:AddLine(self.desc, 1, 1, 1, true) end
    end
    
    GameTooltip:Show() 
end

function Kz.ShowSimpleTooltip(self)
    GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
    GameTooltip:SetText(self.label)
    if self.desc then GameTooltip:AddLine(self.desc, 1, 1, 1, true) end
    GameTooltip:Show()
end

function Kz.HideTooltip()
    GameTooltip:Hide()
end