local AddonName, Kz = ...

function Kz.FormatNumber(n)
    if not n then return "0" end
    if n >= 1e6 then return string.format("%.1fm", n / 1e6) end
    if n >= 1e3 then return string.format("%.1fk", n / 1e3) end
    return tostring(n)
end

function Kz.GetGradientColor(percent)
    if percent >= 100 then return 0, 1, 0 end
    if percent <= 0 then return 1, 0, 0 end
    local r, g = 0, 0
    if percent < 50 then r = 1; g = (percent / 50) else r = (100 - percent) / 50; g = 1 end
    return r, g, 0
end

function Kz.SkinFrame(f, isMain)
    if not f then return end
    if not f.SetBackdrop then Mixin(f, BackdropTemplateMixin) end
    f:SetBackdrop({
        bgFile = "Interface\\Buttons\\WHITE8x8", 
        edgeFile = "Interface\\Buttons\\WHITE8x8", 
        tile = false, tileSize = 0, edgeSize = 1, 
        insets = { left = 0, right = 0, top = 0, bottom = 0 }
    })
    local alpha = (isMain and KazolitusDB and KazolitusDB.opacity) or 0.6
    f:SetBackdropColor(0.06, 0.06, 0.06, alpha)
    f:SetBackdropBorderColor(0, 0, 0, 1)
end

function Kz.SkinIcon(texture)
    if not texture then return end
    texture:SetTexCoord(0.08, 0.92, 0.08, 0.92)
end